/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.object;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.mantle.registration.RegistrationHelper;

public class ItemObject<I extends IForgeRegistryEntry<? super I> & ItemLike>
implements Supplier<I>,
ItemLike {
    private final Supplier<? extends I> entry;
    private final ResourceLocation name;

    public ItemObject(ForgeRegistryEntry<? super I> entry) {
        this.entry = RegistrationHelper.castDelegate(entry.delegate);
        this.name = Objects.requireNonNull(entry.getRegistryName(), () -> "Attempted to create an Item Object with an unregistered entry");
    }

    public ItemObject(RegistryObject<? extends I> object) {
        this.entry = object;
        this.name = object.getId();
    }

    protected ItemObject(ItemObject<? extends I> object) {
        this.entry = object.entry;
        this.name = object.name;
    }

    @Override
    public I get() {
        return (I)Objects.requireNonNull((IForgeRegistryEntry)this.entry.get(), () -> "Item Object not present " + this.name);
    }

    @Nullable
    public I getOrNull() {
        try {
            return (I)((IForgeRegistryEntry)this.entry.get());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public Item m_5456_() {
        return ((ItemLike)this.get()).m_5456_();
    }

    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public ItemObject(Supplier<? extends I> entry, ResourceLocation name) {
        this.entry = entry;
        this.name = name;
    }
}

